@echo off

:: Installing CA certificate requires Administrator privileges.
call :isAdmin

if %errorlevel% == 0 (
  goto :run
) else if "%1" == "admin_session" (
  goto :run
) else if %errorlevel% == 1 (
  goto :UACPrompt
) else (
  echo "Could not get administrative privileges"
  pause
  exit /b
)

:isAdmin
  fsutil dirty query %systemdrive% >nul 2>&1
  exit /b

:run
  cd /d %~dp0
  powershell -NonInteractive -Command "& {Get-ChildItem -Path .\'Kline IKEv2.crt' | Import-Certificate -CertStoreLocation cert:\LocalMachine\root}"
  exit /b

:UACPrompt
  echo Requesting administrative privileges to install the IKEv2 VPN CA certificate...
  echo Set UAC = CreateObject^("Shell.Application"^) > "%temp%\getadminwg.vbs"
  echo UAC.ShellExecute "cmd.exe", "/c ""%~s0"" admin_session", "", "runas", 1 >> "%temp%\getadminwg.vbs"
  "%temp%\getadminwg.vbs"
  del "%temp%\getadminwg.vbs"
  echo Installed the IKEv2 VPN CA certificate.


:: Configuring IKEv2 VPN connection...
powershell -ExecutionPolicy Bypass -f .\ps\AddVPN.ps1
pause
exit /b

